#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// SnakePortalMod01.fsh  by  Del  
//https://www.shadertoy.com/view/7t3Xzr
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// green stuff - Del 04/12/2021

vec2 smoothRot(vec2 p,float s,float m,float c,float d){
  s*=0.5;
  float k=length(p);
  float x=asin(sin(atan(p.x,p.y)*s)*(1.0-m))*k;
  float ds=k*s;
  float y=mix(ds,2.0*ds-sqrt(x*x+ds*ds),c);
  return vec2(x/s,y/s-d);
}

mat2 rotate(float a)
{
	float c = cos(a);
	float s = sin(a);
	return mat2(c, s, -s, c);
} 
//#define k fragColor
//#define p fragCoord
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    vec3 col1 = vec3(0.01,0.03,0.01);
    vec3 col2 = vec3(0.5,0.9,0.3);
    vec2 uv = (fragCoord.xy - 0.5 * iResolution.xy) / iResolution.y;

uv *= rotate(fract(iTime*0.01)*6.28);
    
    float dd2 = length(uv);
    float dd1 = smoothstep(0.0,0.3,dd2);

    //if (abs(uv.x)>0.2)
        col2 *= 1.0-abs(uv.x*0.75);
        col1 *= 1.0-abs(uv.x*0.75);

    float dnoise = 15.0*(dd1);
    //uv *= rotate(-dnoise*0.05);
    
    float dns = 0.5+sin(iTime*.45)*0.5;
    dnoise = mix(dnoise,0.0,dns);
    
    float oo = 0.5+sin(dnoise+uv.y+uv.x*12.0+iTime*0.5)*0.5;
    uv = smoothRot(uv,6.0,0.085,16.0,.075*oo);
    vec2 d = uv*5.0;
    d.x += fract(iTime);
    float v1=length(0.5-fract(d.xy))+0.58;
    d = (uv*1.75);			// zoom
    float v2=length(0.5-fract(d.yy))-0.1525;		// border
    v1 *= 1.2-v2*v1;
    v1 = smoothstep(0.1,0.9,v1);
    vec3 col = mix(col2,col1,v1)*dd1;
    fragColor = vec4(col*4.75,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

